function windowObject()
{
	this.corner = LoadImage("window_corner.png");
	this.circle = LoadImage("window_circle.png");
}

windowObject.prototype.drawWindow = function(x, y, w, h, heading, description)
{
	if (w > 82)
	{
		Rectangle(x - 2, y - 2, (w - 82), h + 4, system.windowLeft);
		Line(x - 2, y - 3, x - 3 + (w - 82), y - 3, colors.black);
		Line(x - 2, y + h + 2, x - 3 + (w - 82), y + h + 2, colors.black);
	}
	GradientRectangle(x - 2 + (w - 82), y - 2, 88, h + 4, system.windowLeft, system.windowRight, system.windowRight, system.windowLeft);
	GradientLineH(x - 2 + (w - 82), y - 3, 88, colors.black, colors.blank);
	Line(x - 3, y - 3, x - 3, y + h + 2, colors.black);
	GradientLineH(x - 2 + (w - 82), y + h + 2, 88, colors.black, colors.blank);
	GradientLineV(x + w + 4, y - 2, h / 2 + 2, colors.blank, colors.black);
	GradientLineV(x + w + 4, y + h / 2, h / 2 + 2, colors.black, colors.blank);
	if (heading != undefined && heading != "" && description != undefined && description != "")
	{
		this.drawWindow(x, y - 13, w, font.main.getStringHeight(description, w) - 4, heading);
		this.corner.blit(x - 3, y - 13);
		font.messageText(x, y - 13, w, font.main.getStringHeight(description, w), description);
	}
	else if (heading != undefined && heading != "")
	{
		this.corner.blit(x - 3, y - 13);
		GradientLineH(x + 7, y - 13, font.getLittleWidth(heading) + 8, colors.black, colors.blank);
		font.littleText(x + 2, y - 11, heading);
	}
	this.circle.blit(x - 6, y - 6);
}

var window = new windowObject();